/*
 *  TC35143
 *
 * 
 *
 */
#ifndef __ASM_ARCH_TC35143_H
#define __ASM_ARCH_TC35143_H 1

#include <asm/hardware.h>
#include <asm/delay.h>

/*
 * TC35143 GPIO Set up data
 */
#define TC35143_GPIO_VERSION0    0	/* GPIO0=Version                 */
#define TC35143_GPIO_TBL_CHK     1	/* GPIO1=TBL_CHK                 */
#define TC35143_GPIO_VPEN_ON     2	/* GPIO2=VPNE_ON                 */
#define TC35143_GPIO_IR_ON       3	/* GPIO3=IR_ON                   */
#define TC35143_GPIO_AMP_ON      4	/* GPIO4=AMP_ON                  */
#define TC35143_GPIO_VERSION1    5	/* GPIO5=Version                 */
#define TC35143_GPIO_FS8KLPF     5	/* GPIO5=fs 8k LPF               */
//#ifdef CONFIG_COLLIE_TR0
#define TC35143_GPIO_CHRG_ON     6	/* GPIO6=CHRG_ON                 */
//#else
#define TC35143_GPIO_BUZZER_BIAS 6	/* GPIO6=BUZZER BIAS             */
//#endif
#define TC35143_GPIO_MBAT_ON     7	/* GPIO7=MBAT_ON                 */
#define TC35143_GPIO_BBAT_ON     8	/* GPIO8=BBAT_ON                 */
#define TC35143_GPIO_TMP_ON      9	/* GPIO9=TMP_ON                  */

#define TC35143_ADC_BAT_TMP      ADC_INPUT_AD0	/* BAT TMP               */
#define TC35143_ADC_BAT_VOL      ADC_INPUT_AD1	/* MAIN/BACKUP BAT VOL   */
#define TC35143_ADC_TC_PRESSURE  ADC_INPUT_AD2 	/* TC PRESSURE           */
#define TC35143_ADC_REMOCON_KEY  ADC_INPUT_AD3	/* REMOCON KEY           */

#define TC35143_IODIR_OUTPUT	 1	/* set up output mode            */
#define TC35143_IODIR_INPUT	 0	/* set up input  mode            */

#define TC35143_IODAT_LOW	 0	/* set up fs 8k LPF on data      */
#define TC35143_IODAT_HIGH	 1	/* set up fs 8k LPF off data     */

#endif
