/*
 * FindAndReplaceDialog.java
 *
 * Created on October 22, 2000, 1:10 PM
 */

package com.SoftWoehr.JaXWT;

/**
 *
 * @author  jax
 * @version
 */
public class FindAndReplaceDialog extends javax.swing.JDialog {

  private FindAndReplaceServer my_server;
  private javax.swing.JFrame my_frame;

  /** Creates new form FindAndReplaceDialog */
  public FindAndReplaceDialog(java.awt.Frame parent,boolean modal) {
    super (parent, modal);
    initComponents ();
    pack ();
  }

  /** Creates new form FindAndReplaceDialog */
  public FindAndReplaceDialog(javax.swing.JFrame parent,boolean modal) {
    super (parent, modal);
    my_frame = parent;
    initComponents ();
    pack ();
  }

  /** Creates new form FindAndReplaceDialog */
  public FindAndReplaceDialog(FindAndReplaceServer frs, javax.swing.JFrame parent,boolean modal) {
    this (parent, modal);
    my_server = frs;
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    jPanel1 = new javax.swing.JPanel ();
    jLabel1 = new javax.swing.JLabel ();
    findComboBox = new javax.swing.JComboBox ();
    jLabel2 = new javax.swing.JLabel ();
    replaceComboBox = new javax.swing.JComboBox ();
    jPanel2 = new javax.swing.JPanel ();
    findBackwardButton = new javax.swing.JButton ();
    replaceBackwardButton = new javax.swing.JButton ();
    replaceAllBackwardButton = new javax.swing.JButton ();
    replaceGlobalButton = new javax.swing.JButton ();
    findForwardButton = new javax.swing.JButton ();
    replaceForwardButton = new javax.swing.JButton ();
    replaceAllForwardButton = new javax.swing.JButton ();
    doneButton = new javax.swing.JButton ();
    clearFindButton = new javax.swing.JButton ();
    clearReplaceButton = new javax.swing.JButton ();
    setTitle ("Find and Replace Tool");
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        closeDialog (evt);
      }
    }
    );

    jPanel1.setLayout (new java.awt.GridLayout (4, 1));
    jPanel1.setBorder (new javax.swing.border.EtchedBorder());

      jLabel1.setText ("Find");
      jLabel1.setToolTipText ("Text to search for.");
  
      jPanel1.add (jLabel1);
  
      findComboBox.setToolTipText ("You can drop down a history of your Finds.");
      findComboBox.setEditable (true);
  
      jPanel1.add (findComboBox);
  
      jLabel2.setText ("Replace with");
      jLabel2.setToolTipText ("Text to replace the found text with.");
  
      jPanel1.add (jLabel2);
  
      replaceComboBox.setToolTipText ("You can drop down a history of your Replace withs.");
      replaceComboBox.setEditable (true);
  
      jPanel1.add (replaceComboBox);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.CENTER);

    jPanel2.setLayout (new java.awt.GridLayout (2, 4));

      findBackwardButton.setToolTipText ("Find next occurence of sought text moving back in file.");
      findBackwardButton.setBorder (new javax.swing.border.EtchedBorder());
      findBackwardButton.setText ("Find Backward");
      findBackwardButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          findBackwardButtonActionPerformed (evt);
        }
      }
      );
  
      jPanel2.add (findBackwardButton);
  
      replaceBackwardButton.setToolTipText ("Replace selected text and find backward again.");
      replaceBackwardButton.setText ("Replace Backward");
      replaceBackwardButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          replaceBackwardButtonActionPerformed (evt);
        }
      }
      );
  
      jPanel2.add (replaceBackwardButton);
  
      replaceAllBackwardButton.setToolTipText ("Replace all occurences from here to top of file.");
      replaceAllBackwardButton.setText ("Replace All Backward");
      replaceAllBackwardButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          replaceAllBackwardButtonActionPerformed (evt);
        }
      }
      );
  
      jPanel2.add (replaceAllBackwardButton);
  
      replaceGlobalButton.setToolTipText ("Replace all occurences of search string in entire file.");
      replaceGlobalButton.setText ("Replace Global");
      replaceGlobalButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          replaceGlobalButtonActionPerformed (evt);
        }
      }
      );
  
      jPanel2.add (replaceGlobalButton);
  
      findForwardButton.setToolTipText ("Find next occurence of sought text moving ahead in file.");
      findForwardButton.setText ("Find Forward");
      findForwardButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          findForwardButtonActionPerformed (evt);
        }
      }
      );
  
      jPanel2.add (findForwardButton);
  
      replaceForwardButton.setToolTipText ("Replace selected text and find forward again.");
      replaceForwardButton.setText ("Replace Forward");
      replaceForwardButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          replaceForwardButtonActionPerformed (evt);
        }
      }
      );
  
      jPanel2.add (replaceForwardButton);
  
      replaceAllForwardButton.setToolTipText ("Replace all occurences from here to end of file.");
      replaceAllForwardButton.setText ("Replace All Forward");
      replaceAllForwardButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          replaceAllForwardButtonActionPerformed (evt);
        }
      }
      );
  
      jPanel2.add (replaceAllForwardButton);
  
      doneButton.setToolTipText ("Finished using this tool, return to application.");
      doneButton.setText ("Done");
      doneButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          doneButtonActionPerformed (evt);
        }
      }
      );
  
      jPanel2.add (doneButton);
  

    getContentPane ().add (jPanel2, java.awt.BorderLayout.SOUTH);

    clearFindButton.setToolTipText ("Clear all the Finds from the drop-down list.");
    clearFindButton.setHorizontalTextPosition (javax.swing.SwingConstants.CENTER);
    clearFindButton.setText ("Clear Find History");
    clearFindButton.addActionListener (new java.awt.event.ActionListener () {
      public void actionPerformed (java.awt.event.ActionEvent evt) {
        clearFindButtonActionPerformed (evt);
      }
    }
    );


    getContentPane ().add (clearFindButton, java.awt.BorderLayout.WEST);

    clearReplaceButton.setToolTipText ("Clear all the Replace withs from the drop-down history list.");
    clearReplaceButton.setHorizontalTextPosition (javax.swing.SwingConstants.CENTER);
    clearReplaceButton.setText ("Clear Replace History");
    clearReplaceButton.addActionListener (new java.awt.event.ActionListener () {
      public void actionPerformed (java.awt.event.ActionEvent evt) {
        clearReplaceButtonActionPerformed (evt);
      }
    }
    );


    getContentPane ().add (clearReplaceButton, java.awt.BorderLayout.EAST);

  }//GEN-END:initComponents

  private void clearReplaceButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearReplaceButtonActionPerformed
    // Add your handling code here:
    replaceComboBox.removeAllItems();
  }//GEN-LAST:event_clearReplaceButtonActionPerformed

  private void clearFindButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearFindButtonActionPerformed
    // Add your handling code here:
    findComboBox.removeAllItems();
  }//GEN-LAST:event_clearFindButtonActionPerformed

  private void replaceBackwardButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_replaceBackwardButtonActionPerformed
    // Add your handling code here:
    if (replace_selected()) {
      push_replace_item();
      find_backward_and_select();
    }
  }//GEN-LAST:event_replaceBackwardButtonActionPerformed

  private void replaceAllBackwardButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_replaceAllBackwardButtonActionPerformed
    // Add your handling code here:
    int num_replaced = 0;
    if (replace_selected()) {
      num_replaced++;
      while (find_backward_and_select()) {
        if (replace_selected()) {
          num_replaced++;
        }
      }
    }
    if (0 == num_replaced) {
      warn_not_found(get_find_string());
    }
    else {
      info_number_replaces(num_replaced);
    }
    push_replace_item();
  }//GEN-LAST:event_replaceAllBackwardButtonActionPerformed

  private void replaceGlobalButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_replaceGlobalButtonActionPerformed
    // Add your handling code here:
    push_find_item();
    push_replace_item();
    int num = my_server.replace_globally(get_find_string(), get_replace_string());
    if (0 == num) {
      warn_not_found(get_find_string());
    }
    else {
      info_number_replaces(num);
    }
  }//GEN-LAST:event_replaceGlobalButtonActionPerformed

  private void findForwardButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_findForwardButtonActionPerformed
    // Add your handling code here:
    if (!find_forward_and_select()) {
      warn_not_found(get_find_string());
    }
    push_find_item();
  }//GEN-LAST:event_findForwardButtonActionPerformed

  private void replaceAllForwardButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_replaceAllForwardButtonActionPerformed
    // Add your handling code here:
    int num_replaced = 0;
    if (replace_selected()) {
      num_replaced++;
      while (find_forward_and_select()) {
        if (replace_selected()) {
          num_replaced++;
        }
      }
    }
    if (0 == num_replaced) {
      warn_not_found(get_find_string());
    }
    else {
      info_number_replaces(num_replaced);
    }
    push_replace_item();
  }//GEN-LAST:event_replaceAllForwardButtonActionPerformed

  private void findBackwardButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_findBackwardButtonActionPerformed
    // Add your handling code here:
    if (!find_backward_and_select()) {
      warn_not_found(get_find_string());
    }
    push_find_item();
  }//GEN-LAST:event_findBackwardButtonActionPerformed

  private void replaceForwardButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_replaceForwardButtonActionPerformed
    // Add your handling code here:
    // Add your handling code here:
    if (replace_selected()) {
      find_forward_and_select();
    }
    push_replace_item();
  }//GEN-LAST:event_replaceForwardButtonActionPerformed

  private void doneButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_doneButtonActionPerformed
    // Add your handling code here:
    setVisible (false);
  }//GEN-LAST:event_doneButtonActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

  /**
   * @param args the command line arguments
   */
  public static void main (String args[]) {
    new FindAndReplaceDialog (new javax.swing.JFrame (), true).show ();
  }


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel jPanel1;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JComboBox findComboBox;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JComboBox replaceComboBox;
  private javax.swing.JPanel jPanel2;
  private javax.swing.JButton findBackwardButton;
  private javax.swing.JButton replaceBackwardButton;
  private javax.swing.JButton replaceAllBackwardButton;
  private javax.swing.JButton replaceGlobalButton;
  private javax.swing.JButton findForwardButton;
  private javax.swing.JButton replaceForwardButton;
  private javax.swing.JButton replaceAllForwardButton;
  private javax.swing.JButton doneButton;
  private javax.swing.JButton clearFindButton;
  private javax.swing.JButton clearReplaceButton;
  // End of variables declaration//GEN-END:variables

  private String get_find_string() {
    return findComboBox.getSelectedItem().toString();
  }

  private String get_replace_string() {
    return replaceComboBox.getSelectedItem().toString();
  }

  private boolean replace_selected () {
    boolean result = false;
    String replacement = get_replace_string();
    if (null == replacement) {
      replacement = "";
    }
    result = my_server.replace_selected(replacement);
    if (!result) {
      warn_nothing_selected();
    }
    return result;
  }

  private boolean find_backward_and_select() {
    boolean result = false;
    if (null != my_server) {
      String s = get_find_string();
      if (null != s) {
        if (!s.equals("")) {
          result = my_server.find_backward_and_select(s);
        }
        else {
          warn_string_is_empty();
        }
      }
      else {
        warn_string_is_empty();
      }
    }
    else {
      warn_no_server_set();
    }
    return result;
  }

  private boolean find_forward_and_select() {
    boolean result = false;
    if (null != my_server) {
      String s = get_find_string();
      if (null != s) {
        if (!s.equals("")) {
          result = my_server.find_forward_and_select(s);
        }
        else {
          warn_string_is_empty();
        }
      }
      else {
        warn_string_is_empty();
      }
    }
    else {
      warn_no_server_set();
    }
    return result;
  }

  private Object makeObj(final String item)  {
    return new Object() {
      public String toString() {
        return item;
      }
    };
  }

  private void push_find_item () {
    if (!combo_has_string(findComboBox, get_find_string())) {
      findComboBox.addItem(makeObj(get_find_string()));
    }
  }

  private void push_replace_item () {
    if (!combo_has_string(replaceComboBox, get_replace_string())) {
      replaceComboBox.addItem(makeObj(get_replace_string()));
    }
  }

  private boolean combo_has_string (javax.swing.JComboBox combo_box, String match) {
    boolean result = false;
    for (int i = 0; i < combo_box.getItemCount(); i++) {
      // System.out.println("Index == " + i + " .. Combo value = " + combo_box.getItemAt(i).toString() + " .. Match == " + match);
      if (combo_box.getItemAt(i).toString().equals(match)) {
        result = true;
        break;
      }
    }
    return result;
  }

  private void warn_no_server_set() {
    StockDialog.showWarningDialog(my_frame, "Not attached to any find and replace server.", "Can't do that");
  }

  private void warn_string_is_empty () {
    StockDialog.showWarningDialog(my_frame, "You entered nothing to search for.", "Nothing to find");
  }

  private void warn_not_found (String s) {
    StockDialog.showWarningDialog(my_frame, "\"" + s + "\"" + " was not found.", "Couldn't find");
  }

  private void warn_nothing_selected() {
    StockDialog.showWarningDialog(my_frame, "Find something first before doing a Replace.", "Nothing Selected, Nothing Replaced");
  }

  private void info_number_replaces(int num) {
    StockDialog.showInfoDialog(my_frame, num + " occurences replaced.", "Replace status");
  }
}
