/*
 * EditPanel.java
 *
 * Copyright *C* 2001 Jack J. Woehr
 * All Rights Reserved
 * PO Box 51, Golden, Colorado 80402-0051 USA
 * http://www.softwoehr.com
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * Free Software NO WARRANTY NO GUARANTEE
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 *
 * Created on October 23, 2000, 3:58 PM
 */

package com.SoftWoehr.JaXWT;

import javax.swing.JFrame;
import java.io.File;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;

/** An experimental predecessor to com.SoftWoehr.JaXWT.EditPanePanel
 * Not currently used in SoftWoehr.
 *
 * @author  jax
 * @version $Id: EditPanel.java,v 1.1.1.1 2001/08/21 02:41:50 jwoehr Exp $
 */
public class EditPanel extends javax.swing.JPanel implements FindAndReplaceServer {
    
    private JFrame my_frame;
    
    private TextFiler my_text_filer = new EditPanelFiler(this);
    
  /** Creates new form EditPanel */
    public EditPanel() {
        initComponents ();
        get_text_area().getDocument().addDocumentListener(new DocumentListener () {
            // Gives notification that an attribute or set of attributes changed.
            public void changedUpdate(DocumentEvent e) {
                status_set_changed(true);
            }
            
            // Gives notification that there was an insert into the document.
            public void insertUpdate(DocumentEvent e) {
                status_set_changed(true);
            }
            
            // Gives notification that a portion of the document has been removed.
            public void removeUpdate(DocumentEvent e) {
                status_set_changed(true);
            }
        });
    }
    
  /** Creates new form EditPanel */
    public EditPanel(JFrame frame) {
        this();
        my_frame = frame;
    }
    
    public JFrame get_frame() {
        return my_frame;
    }
    
  /** Return the text area for direct manipulation */
    public com.SoftWoehr.JaXWT.EditTextArea get_text_area () {
        return my_edit_text_area;
    }
    
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    jScrollPane1 = new javax.swing.JScrollPane ();
    my_edit_text_area = new com.SoftWoehr.JaXWT.EditTextArea ();
    jPanel1 = new javax.swing.JPanel ();
    changedLabel = new javax.swing.JLabel ();
    setLayout (new java.awt.BorderLayout ());


      my_edit_text_area.setFont (new java.awt.Font ("Lucida Sans Unicode", 0, 24));
  
      jScrollPane1.setViewportView (my_edit_text_area);
  

    add (jScrollPane1, java.awt.BorderLayout.CENTER);


      changedLabel.setToolTipText ("Shows \"*\" if file changed since last save.");
  
      jPanel1.add (changedLabel);
  

    add (jPanel1, java.awt.BorderLayout.SOUTH);

  }//GEN-END:initComponents
  
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JScrollPane jScrollPane1;
  private com.SoftWoehr.JaXWT.EditTextArea my_edit_text_area;
  private javax.swing.JPanel jPanel1;
  private javax.swing.JLabel changedLabel;
  // End of variables declaration//GEN-END:variables
  
  // Status
  /////////
  
  /** Set the changed status indicator */
  public void status_set_changed(boolean changed_NOT) {
      if (changed_NOT) {
          changedLabel.setText("*");
      }
      else {
          changedLabel.setText("");
      }
  }
  
  
  // Hi-level editing functionality
  // implementing FindAndReplaceServer
  ////////////////////////////////////
  
  /** Find text and select it. True if found */
  public boolean find_forward_and_select (String s) {
      boolean result = false;
      if (null != s) {
          int pos = my_edit_text_area.getText().indexOf(s, my_edit_text_area.getCaretPosition());
          if (-1 < pos) {
              my_edit_text_area.setCaretPosition(pos);
              my_edit_text_area.moveCaretPosition(pos + s.length());
              result = true;
          }
      }
      return result;
  }
  
  /** Find backwards and hilite. False iff not found */
  public boolean find_backward_and_select(String s) {
      boolean result = false;
      if (null != s) {
          int pos = my_edit_text_area.getText().lastIndexOf(s, java.lang.Math.max(0,my_edit_text_area.getCaretPosition() - 1));
          if (-1 < pos) {
              my_edit_text_area.setCaretPosition(pos + s.length());
              my_edit_text_area.moveCaretPosition(pos);
              // System.out.println("Pos is " + pos + "Caret position is " + getCaretPosition());
              result = true;
          }
      }
      return result;
  }
  
  /** Replace selected with replacement. False iff nothing selected. */
  public boolean replace_selected (String replacement) {
      boolean result = false;
      if (null != my_edit_text_area.getSelectedText()) {
          my_edit_text_area.replaceSelection(replacement);
          result = true;
      }
      return result;
  }
  
  /** Replace all matches with replacement. False iff nothing replaced. */
  public int replace_globally(String sought, String replacement) {
      int result = 0;
      my_edit_text_area.setCaretPosition(0);
      while (find_forward_and_select(sought)) {
          if (null != my_edit_text_area.getSelectedText()) {
              my_edit_text_area.replaceSelection(replacement);
              result++;
          }
      }
      return result;
  }
  
  // Filing
  /////////
  
  /** Get the associated text filer */
  public TextFiler get_filer () {
      return my_text_filer;
  }
  
  /** Get the associated text filer */
  public void set_filer (TextFiler t) {
      my_text_filer = t;
  }
  
  /** Save text to a file.
   * True iff saved.
   */
  public boolean save (File f, int encoding) {
      return save (my_text_filer, f, encoding);
  }
  
  /** Open a file in text area. True iff opened. */
  public boolean open (File f, int encoding) {
      return open(my_text_filer, f, encoding);
  }
  
  /** Insert a file into text area. */
  public boolean insert (File f, int encoding, int position) {
      return insert(my_text_filer, f, encoding, position);
  }
  /** Save text to a file using a specific TextFiler.
   * True iff saved.
   */
  public boolean save (TextFiler t, File f, int encoding) {
      boolean result = t.save(f, encoding);
      if (result) {
          status_set_changed(false);
      }
      return result;
  }
  
  /** Open a file in text area using a specific TextFiler. True iff opened. */
  public boolean open (TextFiler t, File f, int encoding) {
      boolean result = t.open(f, encoding);
      if (result) {
          status_set_changed(false);
      }
      return result;
  }
  
  /** Insert a file into text area using a specific TextFiler. */
  public boolean insert (TextFiler t, File f, int encoding, int position) {
      return t.insert(f, encoding, position);
  }
}