/*
 * EditPanePanel.java
 *
 * Copyright *C* 2001 Jack J. Woehr
 * All Rights Reserved
 * PO Box 51, Golden, Colorado 80402-0051 USA
 * http://www.softwoehr.com
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * Free Software NO WARRANTY NO GUARANTEE
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 *
 * Created on December 11, 2000, 10:53 PM
 */

package com.SoftWoehr.JaXWT;

import javax.swing.JFrame;
import java.io.File;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;

/** The pane which holds the edit region for an editor-type application.
 * @author jax
 * @version $Id: EditPanePanel.java,v 1.1.1.1 2001/08/21 02:41:36 jwoehr Exp $
 */
public class EditPanePanel extends javax.swing.JPanel implements FindAndReplaceServer {
    
    private JFrame my_frame;
    private TextFiler my_text_filer = new EditPanePanelFiler(this);
    
    /** Creates new form EditPanePanel */
    public EditPanePanel() {
        initComponents ();
        get_text_pane().getDocument().addDocumentListener(new DocumentListener () {
            // Gives notification that an attribute or set of attributes changed.
            public void changedUpdate(DocumentEvent e) {
                status_set_changed(true);
            }
            
            // Gives notification that there was an insert into the document.
            public void insertUpdate(DocumentEvent e) {
                status_set_changed(true);
            }
            
            // Gives notification that a portion of the document has been removed.
            public void removeUpdate(DocumentEvent e) {
                status_set_changed(true);
            }
        });
    }
    
    /** Creates new form EditPanel.
     * @param frame The enclosing frame.
     */
    public EditPanePanel(JFrame frame) {
        this();
        my_frame = frame;
    }
    
    /** Return the enclosing frame.
     * @return The enclosing frame.
     */
    public JFrame get_frame() {
        return my_frame;
    }
    
    /** Return the text area for direct manipulation
     * @return  The enclosed text area.
     */
    public com.SoftWoehr.JaXWT.EditTextPane get_text_pane () {
        return my_edit_text_pane;
    }
    
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    my_edit_text_pane = new com.SoftWoehr.JaXWT.EditTextPane ();
    my_status_label = new javax.swing.JLabel ();
    setLayout (new java.awt.BorderLayout ());

    my_edit_text_pane.setFont (new java.awt.Font ("Lucida Sans Unicode", 0, 24));


    add (my_edit_text_pane, java.awt.BorderLayout.CENTER);

    my_status_label.setToolTipText ("Shows status of file.");


    add (my_status_label, java.awt.BorderLayout.SOUTH);

  }//GEN-END:initComponents
  
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private com.SoftWoehr.JaXWT.EditTextPane my_edit_text_pane;
  private javax.swing.JLabel my_status_label;
  // End of variables declaration//GEN-END:variables
  
  // Status
  /////////
  
  /** Set the changed status indicator
   * @param changed_NOT <CODE>true</CODE> means file has been changed.
   */
  public void status_set_changed(boolean changed_NOT) {
      if (changed_NOT) {
          my_status_label.setText("*");
      }
      else {
          my_status_label.setText("");
      }
  }
  
  // Hi-level editing functionality
  // implementing FindAndReplaceServer
  ////////////////////////////////////
  
  /** Find text and select it. True if found.
   * @param s Sought text.
   * @return <CODE>True</CODE> iff found.
   */
  public boolean find_forward_and_select (String s) {
      boolean result = false;
      if (null != s) {
          int pos = my_edit_text_pane.getText().indexOf(s, my_edit_text_pane.getCaretPosition());
          if (-1 < pos) {
              my_edit_text_pane.setCaretPosition(pos);
              my_edit_text_pane.moveCaretPosition(pos + s.length());
              result = true;
          }
      }
      return result;
  }
  
  /** Find backwards and hilite. False iff not found
   * @param s Sought string.
   * @return <CODE>false</CODE> iff not found
   */
  public boolean find_backward_and_select(String s) {
      boolean result = false;
      if (null != s) {
          int pos = my_edit_text_pane.getText().lastIndexOf(s, java.lang.Math.max(0,my_edit_text_pane.getCaretPosition() - 1));
          if (-1 < pos) {
              my_edit_text_pane.setCaretPosition(pos + s.length());
              my_edit_text_pane.moveCaretPosition(pos);
              // System.out.println("Pos is " + pos + "Caret position is " + getCaretPosition());
              result = true;
          }
      }
      return result;
  }
  
  /** Replace selected with replacement. False iff nothing selected.
   * @param replacement Replacement text.
   * @return <CODE>false</CODE> iff nothing selected.
   */
  public boolean replace_selected (String replacement) {
      boolean result = false;
      if (null != my_edit_text_pane.getSelectedText()) {
          my_edit_text_pane.replaceSelection(replacement);
          result = true;
      }
      return result;
  }
  
  /** Replace all matches with replacement. False iff nothing replaced.
   * @param sought Sought string.
   * @param replacement Replacement text.
   * @return <CODE>false</CODE> iff nothing replaced.
   */
  public int replace_globally(String sought, String replacement) {
      int result = 0;
      my_edit_text_pane.setCaretPosition(0);
      while (find_forward_and_select(sought)) {
          if (null != my_edit_text_pane.getSelectedText()) {
              my_edit_text_pane.replaceSelection(replacement);
              result++;
          }
      }
      return result;
  }
  
  // Filing
  /////////
  
  /** Get the associated text filer.
   * @return Associated filer.
   */
  public TextFiler get_filer () {
      return my_text_filer;
  }
  
  /** Get the associated text filer
   * @param t Associated filer.
   */
  public void set_filer (TextFiler t) {
      my_text_filer = t;
  }
  
  /** Save text to a file.
   * True iff saved.
   * @param f The File to save to.
   * @param encoding Character encoding desired for file save.
   * @return <CODE>true</CODE> iff saved.
   * @see com.SoftWoehr.JaXWT.EditPanePanelFiler
   */
  public boolean save (File f, int encoding) {
      return save (my_text_filer, f, encoding);
  }
  
  /** Open a file in text area. True iff opened.
   * @param f The File to open.
   * @param encoding Character encoding of file.
   * @return <CODE>true</CODE> iff opened succesfully.
   * @see com.SoftWoehr.JaXWT.EditPanePanelFiler
   */
  public boolean open (File f, int encoding) {
      return open(my_text_filer, f, encoding);
  }
  
  /** Insert a file into text area.
   * @param f File to insert.
   * @param encoding Character encoding of file.
   * @param position Offset (0-based) at which to insert file.
   * @return <CODE>true</CODE> if success.
   * @see com.SoftWoehr.JaXWT.EditPanePanelFiler
   */
  public boolean insert (File f, int encoding, int position) {
      return insert(my_text_filer, f, encoding, position);
  }
  /** Save text to a file using a specific TextFiler.
   * True iff saved.
   * @param t Text to save.
   * @param f File to save to.
   * @param encoding Character encoding of file.
   * @return <CODE>true</CODE>if success.
   * @see com.SoftWoehr.JaXWT.EditPanePanelFiler
   */
  public boolean save (TextFiler t, File f, int encoding) {
      boolean result = t.save(f, encoding);
      if (result) {
          status_set_changed(false);
      }
      return result;
  }
  
  /** Open a file in text area using a specific TextFiler. True iff opened.
   * @param t TextFiler to use
   * @param f File to open.
   * @param encoding Character encoding of file.
   * @return <CODE>true</CODE>if success.
   * @see com.SoftWoehr.JaXWT.EditPanePanelFiler
   */
  public boolean open (TextFiler t, File f, int encoding) {
      boolean result = t.open(f, encoding);
      if (result) {
          status_set_changed(false);
      }
      return result;
  }
  
  /** Insert a file into text area using a specific TextFiler.
   * @param t Text filer to use.
   * @param f File to insert
   * @param encoding Character encoding of file.
   * @param position Offset (0-based) at which to insert file.
   * @return <CODE>true</CODE> if success.
   * @see com.SoftWoehr.JaXWT.EditPanePanelFiler
   */
  public boolean insert (TextFiler t, File f, int encoding, int position) {
      return t.insert(f, encoding, position);
  }
  
}