/*
 * FijiPanel.java
 *
 * Copyright *C* 2001 Jack J. Woehr
 * All Rights Reserved
 * PO Box 51, Golden, Colorado 80402-0051 USA
 * http://www.softwoehr.com
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * Free Software NO WARRANTY NO GUARANTEE
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 *
 * Created on October 11, 2000, 3:21 PM
 */

package com.SoftWoehr.FIJI;

import com.SoftWoehr.JaXWT.JTextAreaOutputStream;

/**
 * The panel which contains the whole FIJI Gui layout.
 * Controlled by its FijiPanelController, it fits right
 * in the FijiFrame.
 * @author  jax
 * @version $Id: FijiPanel.java,v 1.1.1.1 2001/08/21 02:36:57 jwoehr Exp $
 */
public class FijiPanel extends javax.swing.JPanel {
    
    FijiPanelController my_controller;
    FijiFrame my_frame;
    
    /** Creates new form FijiPanel.
     * This ctor only useful for the design editor which
     * needs a zero-arity ctor at design time.
     */
    public FijiPanel() {
        this(null, null);
    }
    
    /** Creates new form FijiPanel passing in app controller and frame.
     * @param fg The application controller FIJIGui.
     * @param frame  The FijiFrame in which it fits. */
    public FijiPanel(FIJIGui fg, FijiFrame frame) {
        my_frame = frame;
        my_controller = new FijiPanelController(fg, this);
        initComponents();
        my_controller.activate();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
  private void initComponents () {//GEN-BEGIN:initComponents
    fijiInputPanel = new FijiInputPanel(get_controller());
    jScrollPane1 = new javax.swing.JScrollPane ();
    fijiTextArea = new com.SoftWoehr.FIJI.FijiTextArea ();
    setLayout (new java.awt.BorderLayout ());



    add (fijiInputPanel, java.awt.BorderLayout.SOUTH);


      fijiTextArea.setFont (new java.awt.Font ("Monospaced", 0, 12));
  
      jScrollPane1.setViewportView (fijiTextArea);
  

    add (jScrollPane1, java.awt.BorderLayout.CENTER);

  }//GEN-END:initComponents
  
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private com.SoftWoehr.FIJI.FijiInputPanel fijiInputPanel;
  private javax.swing.JScrollPane jScrollPane1;
  private com.SoftWoehr.FIJI.FijiTextArea fijiTextArea;
  // End of variables declaration//GEN-END:variables
  
  /** Return the FijiTextArea so controller can read and write it.
   * @return the FijiTextArea */
  public FijiTextArea get_text_area() {
      return fijiTextArea;
  }
  
  /** Return the FijiInputPanel so controller can read and write it.
   * @return the FijiInputPanel */
  public FijiInputPanel get_input_panel() {
      return fijiInputPanel;
  }
  
  /** Return the controller
   * @return the FijiPanelController */
  protected FijiPanelController get_controller() {
      return my_controller;
  }
  
  /** Return the frame
   * @return the associated FijiFrame */
  protected FijiFrame get_frame() {
      return my_frame;
  }
}