/*
 * FijiFrame.java
 *
 * Copyright *C* 2001 Jack J. Woehr
 * All Rights Reserved
 * PO Box 51, Golden, Colorado 80402-0051 USA
 * http://www.softwoehr.com
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * Free Software NO WARRANTY NO GUARANTEE
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 *
 * Created on October 13, 2000, 6:27 PM
 */

package com.SoftWoehr.FIJI;

/** The Frame inside which a FIJI Panel opens. FijiFrame has
 * the hooks to the application controller and also to the
 * panel controller for the FijiPanel it contains.
 * @author  jax
 * @version $Id: FijiFrame.java,v 1.1.1.1 2001/08/21 02:35:53 jwoehr Exp $
 */
public class FijiFrame extends javax.swing.JFrame {
    
    /** Our icon image */
    private javax.swing.ImageIcon icon;
    private FIJIGui my_application_controller;
    
    /** Creates new form FijiFrame */
    public FijiFrame() {
        this(null);
    }
    
    /** Creates new FijiFrame with an associated application controller
     * @param fiji The application controller.
 */
    public FijiFrame(FIJIGui fiji) {
        my_application_controller = fiji;
        initComponents ();
        loadIcon("com/SoftWoehr/images/fiji.jpg", "FIJI Icon");
        pack ();
    }
    
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
    private void initComponents() {//GEN-BEGIN:initComponents
        menuBar = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        fileNewMenuItem = new javax.swing.JMenuItem();
        fileOpenMenuItem = new javax.swing.JMenuItem();
        fileInsertMenuItem = new javax.swing.JMenuItem();
        jSeparator4 = new javax.swing.JSeparator();
        fileSaveMenuItem = new javax.swing.JMenuItem();
        fileSaveAsMenuItem = new javax.swing.JMenuItem();
        fileSaveSelectedMenuItem = new javax.swing.JMenuItem();
        jSeparator3 = new javax.swing.JSeparator();
        fileExitMenuItem = new javax.swing.JMenuItem();
        editMenu = new javax.swing.JMenu();
        editCutMenuItem = new javax.swing.JMenuItem();
        editCopyMenuItem = new javax.swing.JMenuItem();
        editPasteMenuItem = new javax.swing.JMenuItem();
        editSelectAllMenuItem = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JSeparator();
        editFindMenuItem = new javax.swing.JMenuItem();
        editReplaceMenuItem = new javax.swing.JMenuItem();
        interpretMenu = new javax.swing.JMenu();
        interpretSelectedMenuItem = new javax.swing.JMenuItem();
        interpretLoadMenuItem = new javax.swing.JMenuItem();
        helpMenu = new javax.swing.JMenu();
        helpMenuItem = new javax.swing.JMenuItem();
        aboutMenuItem = new javax.swing.JMenuItem();
        jScrollPane1 = new javax.swing.JScrollPane();
        fijiPanel = new FijiPanel(get_application_controller(), this);
        
        fileMenu.setToolTipText("Files and closing FIJI");
        fileMenu.setMnemonic(java.awt.event.KeyEvent.VK_F);
        fileMenu.setText("File");
        
        fileNewMenuItem.setToolTipText("Empty the text area and reinstance as a new file.");
        fileNewMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_N);
        fileNewMenuItem.setText("New");
        fileNewMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileNewMenuItemActionPerformed(evt);
            }
        }
        );
        fileMenu.add(fileNewMenuItem);
        
        fileOpenMenuItem.setToolTipText("Open a file in the text area, replacing the text area's contents.");
        fileOpenMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_O);
        fileOpenMenuItem.setText("Open");
        fileOpenMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileOpenMenuItemActionPerformed(evt);
            }
        }
        );
        fileMenu.add(fileOpenMenuItem);
        
        fileInsertMenuItem.setToolTipText("Insert a file into the text area at current cursor.");
        fileInsertMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_I);
        fileInsertMenuItem.setText("Insert");
        fileInsertMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileInsertMenuItemActionPerformed(evt);
            }
        }
        );
        fileMenu.add(fileInsertMenuItem);
        
        fileMenu.add(jSeparator4);
        
        fileSaveMenuItem.setToolTipText("Save contents of the text area to file.");
        fileSaveMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_S);
        fileSaveMenuItem.setText("Save");
        fileSaveMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileSaveMenuItemActionPerformed(evt);
            }
        }
        );
        fileMenu.add(fileSaveMenuItem);
        
        fileSaveAsMenuItem.setToolTipText("Save contents of the edit area under a changed filename.");
        fileSaveAsMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_A);
        fileSaveAsMenuItem.setText("Save as");
        fileSaveAsMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileSaveAsMenuItemActionPerformed(evt);
            }
        }
        );
        fileMenu.add(fileSaveAsMenuItem);
        
        fileSaveSelectedMenuItem.setToolTipText("Save selected text from edit area to file.");
        fileSaveSelectedMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_L);
        fileSaveSelectedMenuItem.setText("Save Selected");
        fileSaveSelectedMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileSaveSelectedMenuItemActionPerformed(evt);
            }
        }
        );
        fileMenu.add(fileSaveSelectedMenuItem);
        
        fileMenu.add(jSeparator3);
        
        fileExitMenuItem.setToolTipText("Bye!");
        fileExitMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_X);
        fileExitMenuItem.setText("Exit");
        fileExitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileExitMenuItemActionPerformed(evt);
            }
        }
        );
        fileMenu.add(fileExitMenuItem);
        menuBar.add(fileMenu);
        
        editMenu.setToolTipText("Editing the text area");
        editMenu.setMnemonic(java.awt.event.KeyEvent.VK_E);
        editMenu.setText("Edit");
        
        editCutMenuItem.setToolTipText("Cut to clipboard.");
        editCutMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_C);
        editCutMenuItem.setText("Cut");
        editCutMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editCutMenuItemActionPerformed(evt);
            }
        }
        );
        editMenu.add(editCutMenuItem);
        
        editCopyMenuItem.setToolTipText("Copy into clipboard.");
        editCopyMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_O);
        editCopyMenuItem.setText("Copy");
        editCopyMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editCopyMenuItemActionPerformed(evt);
            }
        }
        );
        editMenu.add(editCopyMenuItem);
        
        editPasteMenuItem.setToolTipText("Copy from clipboard.");
        editPasteMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_P);
        editPasteMenuItem.setText("Paste");
        editPasteMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editPasteMenuItemActionPerformed(evt);
            }
        }
        );
        editMenu.add(editPasteMenuItem);
        
        editSelectAllMenuItem.setToolTipText("Select all the text in the text area.");
        editSelectAllMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_A);
        editSelectAllMenuItem.setText("Select All");
        editSelectAllMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editSelectAllMenuItemActionPerformed(evt);
            }
        }
        );
        editMenu.add(editSelectAllMenuItem);
        
        editMenu.add(jSeparator2);
        
        editFindMenuItem.setToolTipText("Find text");
        editFindMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_I);
        editFindMenuItem.setText("Find");
        editFindMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editFindMenuItemActionPerformed(evt);
            }
        }
        );
        editMenu.add(editFindMenuItem);
        
        editReplaceMenuItem.setToolTipText("Find text and replace it.");
        editReplaceMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_R);
        editReplaceMenuItem.setText("Replace");
        editReplaceMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editReplaceMenuItemActionPerformed(evt);
            }
        }
        );
        editMenu.add(editReplaceMenuItem);
        menuBar.add(editMenu);
        
        interpretMenu.setToolTipText("Fiji interpreter");
        interpretMenu.setMnemonic(java.awt.event.KeyEvent.VK_J);
        interpretMenu.setText("Fiji");
        
        interpretSelectedMenuItem.setToolTipText("Forward selected text to Fiji interpreter.");
        interpretSelectedMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_I);
        interpretSelectedMenuItem.setText("Interpret Selected");
        interpretSelectedMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                interpretSelectedMenuItemActionPerformed(evt);
            }
        }
        );
        interpretMenu.add(interpretSelectedMenuItem);
        
        interpretLoadMenuItem.setToolTipText("Load and interpret a FIJI source file.");
        interpretLoadMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_L);
        interpretLoadMenuItem.setText("Load FIJI Source");
        interpretLoadMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                interpretLoadMenuItemActionPerformed(evt);
            }
        }
        );
        interpretMenu.add(interpretLoadMenuItem);
        menuBar.add(interpretMenu);
        
        helpMenu.setToolTipText("Help and About");
        helpMenu.setMnemonic(java.awt.event.KeyEvent.VK_H);
        helpMenu.setText("Help");
        
        helpMenuItem.setToolTipText("Get help");
        helpMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_L);
        helpMenuItem.setText("Help");
        helpMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpMenuItemActionPerformed(evt);
            }
        }
        );
        helpMenu.add(helpMenuItem);
        
        aboutMenuItem.setToolTipText("About Fiji ForthIsh Java Interpreter");
        aboutMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_A);
        aboutMenuItem.setText("About");
        aboutMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                aboutMenuItemActionPerformed(evt);
            }
        }
        );
        helpMenu.add(aboutMenuItem);
        menuBar.add(helpMenu);
        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        }
        );
        
        
        fijiPanel.setPreferredSize(new java.awt.Dimension(600, 400));
        jScrollPane1.setViewportView(fijiPanel);
        
        
        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);
        
        setJMenuBar(menuBar);
        
    }//GEN-END:initComponents
    
  private void interpretLoadMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_interpretLoadMenuItemActionPerformed
      // Add your handling code here:
      get_panel_controller().event_load(evt);
  }//GEN-LAST:event_interpretLoadMenuItemActionPerformed
  
  private void fileSaveSelectedMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileSaveSelectedMenuItemActionPerformed
      // Add your handling code here:
      get_panel_controller().event_save_selected(evt);
  }//GEN-LAST:event_fileSaveSelectedMenuItemActionPerformed
  
  private void fileSaveAsMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileSaveAsMenuItemActionPerformed
      // Add your handling code here:
      get_panel_controller().event_save_as(evt);
  }//GEN-LAST:event_fileSaveAsMenuItemActionPerformed
  
  private void editPasteMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editPasteMenuItemActionPerformed
      // Add your handling code here:
      get_panel_text_area().paste();
  }//GEN-LAST:event_editPasteMenuItemActionPerformed
  
  private void editCopyMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editCopyMenuItemActionPerformed
      // Add your handling code here:
      get_panel_text_area().copy();
  }//GEN-LAST:event_editCopyMenuItemActionPerformed
  
  private void editCutMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editCutMenuItemActionPerformed
      // Add your handling code here:
      get_panel_text_area().cut();
  }//GEN-LAST:event_editCutMenuItemActionPerformed
  
  private void editSelectAllMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editSelectAllMenuItemActionPerformed
      // Add your handling code here:
      get_panel_text_area().selectAll();
  }//GEN-LAST:event_editSelectAllMenuItemActionPerformed
  
  private void editFindMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editFindMenuItemActionPerformed
      // Add your handling code here:
      get_panel_controller().event_find(evt);
  }//GEN-LAST:event_editFindMenuItemActionPerformed
  
  private void editReplaceMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editReplaceMenuItemActionPerformed
      // Add your handling code here:
      get_panel_controller().event_replace(evt);
  }//GEN-LAST:event_editReplaceMenuItemActionPerformed
  
  private void interpretSelectedMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_interpretSelectedMenuItemActionPerformed
      // Add your handling code here:
      get_panel_controller().event_interpret_selected(evt);
  }//GEN-LAST:event_interpretSelectedMenuItemActionPerformed
  
  private void fileExitMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileExitMenuItemActionPerformed
      // Add your handling code here:
      exit_requested();
  }//GEN-LAST:event_fileExitMenuItemActionPerformed
  
  private void fileSaveMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileSaveMenuItemActionPerformed
      // Add your handling code here:
      get_panel_controller().event_save(evt);
  }//GEN-LAST:event_fileSaveMenuItemActionPerformed
  
  private void aboutMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aboutMenuItemActionPerformed
      // Add your handling code here:
  }//GEN-LAST:event_aboutMenuItemActionPerformed
  
  private void helpMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpMenuItemActionPerformed
      // Add your handling code here:
  }//GEN-LAST:event_helpMenuItemActionPerformed
  
  private void fileNewMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileNewMenuItemActionPerformed
      // Add your handling code here:
      get_panel_controller().event_new(evt);
  }//GEN-LAST:event_fileNewMenuItemActionPerformed
  
  private void fileOpenMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileOpenMenuItemActionPerformed
      // Add your handling code here:
      get_panel_controller().event_open(evt);
  }//GEN-LAST:event_fileOpenMenuItemActionPerformed
  
  private void fileInsertMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileInsertMenuItemActionPerformed
      // Add your handling code here:
  }//GEN-LAST:event_fileInsertMenuItemActionPerformed
  
  /** Exit the Application */
  private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
      exit_requested();
  }//GEN-LAST:event_exitForm
  
  /** Test run a FIJI frame.
   * @param args the command line arguments
   */
  public static void main (String args[]) {
      new FijiFrame ().show ();
  }
  
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JMenuBar menuBar;
  private javax.swing.JMenu fileMenu;
  private javax.swing.JMenuItem fileNewMenuItem;
  private javax.swing.JMenuItem fileOpenMenuItem;
  private javax.swing.JMenuItem fileInsertMenuItem;
  private javax.swing.JSeparator jSeparator4;
  private javax.swing.JMenuItem fileSaveMenuItem;
  private javax.swing.JMenuItem fileSaveAsMenuItem;
  private javax.swing.JMenuItem fileSaveSelectedMenuItem;
  private javax.swing.JSeparator jSeparator3;
  private javax.swing.JMenuItem fileExitMenuItem;
  private javax.swing.JMenu editMenu;
  private javax.swing.JMenuItem editCutMenuItem;
  private javax.swing.JMenuItem editCopyMenuItem;
  private javax.swing.JMenuItem editPasteMenuItem;
  private javax.swing.JMenuItem editSelectAllMenuItem;
  private javax.swing.JSeparator jSeparator2;
  private javax.swing.JMenuItem editFindMenuItem;
  private javax.swing.JMenuItem editReplaceMenuItem;
  private javax.swing.JMenu interpretMenu;
  private javax.swing.JMenuItem interpretSelectedMenuItem;
  private javax.swing.JMenuItem interpretLoadMenuItem;
  private javax.swing.JMenu helpMenu;
  private javax.swing.JMenuItem helpMenuItem;
  private javax.swing.JMenuItem aboutMenuItem;
  private javax.swing.JScrollPane jScrollPane1;
  private com.SoftWoehr.FIJI.FijiPanel fijiPanel;
  // End of variables declaration//GEN-END:variables
  
  // The Icon
  ///////////
  /** Load the icon for the frame.
   * @param iconPath Classpath to the icon to load.
   * @param description Description of icon.
   * @return True iff icon loaded.
 */
  protected boolean loadIcon (String iconPath, String description) {
      boolean result = false;
      java.net.URL iconURL = ClassLoader.getSystemResource(iconPath);
      if (iconURL != null) {
          icon = new javax.swing.ImageIcon(iconURL, description);
          if (null != icon)
          {
              setIconImage(icon.getImage());
              result = true;
          }
      }
      return result;
  }
  
  // Controllers, Panel and Text Area
  ///////////////////////////////////
  
  /** Return the application controller associated with this frame
   * @return The application controller.
   */
  protected FIJIGui get_application_controller () {
      return my_application_controller;
  }
  
  /** Return the frame controller of the panel associated with this frame.
   * @return The frame controller of the panel associated with this frame.
   */
  protected FijiPanelController get_panel_controller () {
      return fijiPanel.get_controller();
  }
  
  /** Return the controller of the panel associated with this frame.
   * @return The controller of the panel associated with this frame.
   */
  protected FijiTextArea get_panel_text_area () {
      return fijiPanel.get_text_area();
  }
  
  // Closing and Exiting
  //////////////////////
  
  /** Exit if permitted */
  private void exit_requested () {
      if (may_i_exit()) {
          setVisible(false);
          dispose();
          if (may_i_system_exit()) {
              System.exit (0);
          }
      }
  }
  
  /** Ask panel controller if one may close.
   * @return True if panel controller thinks it's okay to close.
   */
  protected boolean may_i_close() {
      return get_panel_controller().close_requested();
  }
  
  /** Ask application controller if one may exit.
   * @return True if application controller thinks it's okay for FIJI to exit.
   */
  protected boolean may_i_exit() {
      boolean result = false;
      if (may_i_close()) { // Ask panel controller about close
          if (null != my_application_controller) { // If app controller
              if (my_application_controller.exit_requested(this)) {
                  result = true; // Ask app controller about exit
              }
              else { // No app controller (but panel said okay to close)
                  result = true;
              }
          }
      }
      return result;
  }
  
   /** Ask app controller if it's okay to call System.exit() on exiting FIJI. This allows FIJI to be launched
    * from a toolbar without closing the toolbar when FIJI exits.
    * @return True if System.exit() should be called on FIJI exit.
    */
  protected boolean may_i_system_exit() {
      return my_application_controller.system_exit_requested(this);
  }
}